/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.control;

import com.mckoi.database.Database;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.control.DBConfig;
import com.mckoi.database.control.DBController;
import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbcserver.JDBCDatabaseInterface;
import java.sql.Connection;
import java.sql.SQLException;

public final class DBSystem {
    private DBController controller;
    private DBConfig config;
    private Database database;
    private int internal_counter;

    DBSystem(DBController controller, DBConfig config, Database database) {
        this.controller = controller;
        this.config = config;
        this.database = database;
        this.internal_counter = 0;
        database.registerShutDownDelegate(new Runnable(){

            public void run() {
                DBSystem.this.internalDispose();
            }
        });
        database.setIsExecutingCommands(true);
    }

    public DBConfig getConfig() {
        return this.config;
    }

    public Database getDatabase() {
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String schema, String username, String password) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("Internal/");
        buf.append(this.hashCode());
        buf.append('/');
        DBSystem dBSystem = this;
        synchronized (dBSystem) {
            buf.append(this.internal_counter);
            ++this.internal_counter;
        }
        String host_string = new String(buf);
        JDBCDatabaseInterface db_interface = new JDBCDatabaseInterface(this.getDatabase(), host_string);
        MConnection connection = new MConnection("", db_interface, 8, 4092000);
        connection.login(schema, username, password);
        return connection;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection(null, username, password);
    }

    public final void setDeleteOnClose(boolean status) {
        this.database.setDeleteOnShutdown(status);
    }

    public void close() {
        if (this.database != null) {
            this.database.startShutDownThread();
            this.database.waitUntilShutdown();
        }
    }

    private void internalDispose() {
        if (this.database != null && this.database.isInitialized()) {
            this.database.setIsExecutingCommands(false);
            try {
                this.database.shutdown();
            }
            catch (DatabaseException e) {
                this.database.Debug().write(40, this, "Unable to shutdown database because of exception");
                this.database.Debug().writeException(40, e);
            }
        }
        this.controller = null;
        this.config = null;
        this.database = null;
    }
}

